/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.config.IConfigLockedListEntry;
import fi.dy.masa.malilib.config.IConfigLockedListType;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ConfigTestLockedList
implements IConfigLockedListType {
    public static final ConfigTestLockedList INSTANCE = new ConfigTestLockedList();
    public ImmutableList<Entry> VALUES = ImmutableList.copyOf((Object[])Entry.values());
    public static final Codec<ConfigTestLockedList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Entry.CODEC.listOf().fieldOf("values").forGetter(get -> get.VALUES)).apply((Applicative)inst, ConfigTestLockedList::new));

    private ConfigTestLockedList() {
    }

    private ConfigTestLockedList(List<Entry> list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        list.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.VALUES = ImmutableList.builder().build();
    }

    @Override
    public ImmutableList<IConfigLockedListEntry> getDefaultEntries() {
        ImmutableList.Builder list = ImmutableList.builder();
        this.VALUES.forEach(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
        return list.build();
    }

    @Override
    @Nullable
    public IConfigLockedListEntry fromString(String element) {
        return Entry.fromString(element);
    }

    public static enum Entry implements IConfigLockedListEntry,
    StringRepresentable
    {
        TEST1("test1", "test1"),
        TEST2("test2", "test2"),
        TEST3("test3", "test3"),
        TEST4("test4", "test4");

        public static final StringRepresentable.EnumCodec<Entry> CODEC;
        public static final ImmutableList<Entry> VALUES;
        private final String configKey;
        private final String translationKey;

        private Entry(String configKey, String translationKey) {
            this.configKey = configKey;
            this.translationKey = "malilib.gui.label.locked_test." + translationKey;
        }

        @Override
        public String getStringValue() {
            return this.configKey;
        }

        @Override
        public String getDisplayName() {
            return StringUtils.getTranslatedOrFallback(this.translationKey, this.configKey);
        }

        @Nullable
        public static Entry fromString(String key) {
            for (Entry entry : Entry.values()) {
                if (entry.configKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (entry.translationKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (!StringUtils.hasTranslation(entry.translationKey) || !StringUtils.translate(entry.translationKey, new Object[0]).equalsIgnoreCase(key)) continue;
                return entry;
            }
            return null;
        }

        @Nonnull
        public String getSerializedName() {
            return this.configKey;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Entry::values);
            VALUES = ImmutableList.copyOf((Object[])Entry.values());
        }
    }
}

